﻿<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Deklaracje" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie PIT-8AR</title>
		<script runat="server">

    public class Params: ContextBase {
        
        public Params(Context context): base(context) {
            InitRok();
        }
    
        void InitRok() {
            Date data = Date.MinValue;
            if (Context.Contains(typeof(ActualDate)))
                data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
            if (data==Date.MinValue || data==Date.MaxValue)
                data = Date.Today;
            rok = data.Month<12 ? data.Year-1 : data.Year;
        }
    
        int rok;
        [Required]
        public int Rok {
            get { return rok; }
            set {
                rok = value;
                if (rok==0)
                    InitRok();
                OnChanged(EventArgs.Empty);
            }
        }
    
        UrzadSkarbowy urzad;
        public UrzadSkarbowy Urzad {
            get { return urzad; }
            set {
                urzad = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
    
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }
    
    class Podatnik {
        readonly Pracownik pracownik;
        readonly UrzadSkarbowy urzad;
        readonly FromTo okres;
    
        readonly string nazwiskoImie;
    
        readonly decimal przychod;
        readonly decimal koszty;
        readonly decimal podatek;
        readonly decimal zus;
        readonly decimal pobrane;
        readonly decimal doOdliczenia;

        public Podatnik(Pracownik pracownik, FromTo okres, FromTo minokres) {
            this.pracownik = pracownik;
            PracHistoria ph = pracownik[okres.To];

            urzad = (UrzadSkarbowy)ph.Podatki.UrzadSkarbowy;
            nazwiskoImie = ph.Nazwisko + " " + ph.Imie;

            SubTable wypłaty = new SubTable(pracownik.Wyplaty, okres);
            foreach (Soneta.Place.Wyplata wyplata in wypłaty)
                foreach (WypElement element in wyplata.Elementy) {
                    DefinicjaElementu definicja = element.Definicja;
                    PozycjaPIT pozpit = definicja.Deklaracje.PozycjaPIT;
                    if (pozpit != null && pozpit.PIT8AR > 0 && element.Podatek) {
                        przychod += element.DoOpodatkowania;
                        koszty += element.Podatki.Koszty + element.Podatki.Koszty50;
                        podatek += element.Podatki.ZalFIS;

                        if (element.MiesiacZUS != element.MiesiacDeklaracji)
                            przychod -= element.Podatki.KosztyZUS;

                        if (element.MiesiacZUS == element.MiesiacDeklaracji)
                            zus += element.Podatki.KosztyZUS;

                        pobrane += element.Podatki.Zdrowotna.Prac;
                        doOdliczenia += element.Podatki.ZdrowotneDoOdliczenia;
                    }
                }

            this.okres = minokres;
        }

        public string NazwiskoImieOkres {
            get { return nazwiskoImie + "<br>" + okres.ToString(); }
        }
        public FromTo Okres {
            get { return okres; }
        }
        public Pracownik Pracownik {
            get { return pracownik; }
        }
        public UrzadSkarbowy Urzad {
            get { return urzad; }
        }
        public decimal Przychod {
            get { return przychod; }
        }
        public decimal Koszty {
            get { return koszty; }
        }
        public decimal Dochod {
            get { return przychod-koszty; }
        }
        public decimal Podatek {
            get { return podatek; }
        }
        public decimal ZUS {
            get { return zus; }
        }
        public decimal Pobrane {
            get { return pobrane; }
        }
        public decimal DoOdliczenia {
            get { return doOdliczenia; }
        }
    }
    
    class UrzadSk: IComparable {
        readonly UrzadSkarbowy urzad;
        readonly ArrayList podatnicy = new ArrayList();
    
        public UrzadSk(UrzadSkarbowy urzad) {
            this.urzad = urzad;
        }
        public void Add(Podatnik podatnik) {
            podatnicy.Add(podatnik);
        }
        public UrzadSkarbowy Urzad {
            get { return urzad; }
        }
        public IEnumerable Podatnicy {
            get { return podatnicy; }
        }
    
        int IComparable.CompareTo(object v) {
            if (v==null)
                return 1;
            UrzadSk us = v as UrzadSk;
            if (us==null)
                throw new ArgumentException();
            if (urzad==null)
                return us.urzad==null ? 0 : -1;
            if (us.urzad==null)
                return 1;
            return urzad.Nazwa.CompareTo(us.urzad.Nazwa);
        }
    }
    
    Hashtable urzedy = new Hashtable();
		    
    void dc_ContextLoad(Object sender, EventArgs e) {

        bool uwzględniajSkładkiZPIT8AR = DeklaracjeModule.GetInstance(dc).Config.PIT.PIT11.UwzględniajSkładkiZPIT8AR;
        
        ReportHeader["ROK"] = pars.Rok.ToString();
        ReportHeader["URZAD"] = pars.Urzad==null ? "(wszystkie)" : pars.Urzad.Nazwa;
        ReportHeader["SKŁADKI"] = uwzględniajSkładkiZPIT8AR ? "|Składki od przychodów wykazywanych na PIT-8AR zostaną uwzględnione na PIT-11" : "";

        FromTo rok = FromTo.Year(pars.Rok);
    
        Row[] rows = (Row[])dc[typeof(Row[])];
        foreach (Pracownik idx in rows)
            Wylicz(idx, rok, FromTo.Empty);

        ArrayList lista = new ArrayList(urzedy.Values);
        lista.Sort();
    
        DataRepeater1.DataSource = lista;
    }

    void Wylicz(Pracownik pracownik, FromTo okres, FromTo minokres) {
        Podatnik pod = new Podatnik(pracownik, okres, minokres);
        if (pod.Przychod>0m || pod.Pobrane>0m) {
            UrzadSkarbowy us = pod.Urzad;
            if (pars.Urzad==null || pars.Urzad==us) {
                object key = us!=null ? (object)us : (object)1;
                UrzadSk urzad = (UrzadSk)urzedy[key];
                if (urzad==null)
                    urzedy[key] = urzad = new UrzadSk(us);
                urzad.Add(pod);
            }
        }
    }

            static object Msg(object value) {
                return value;
            }        

		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Zestawienie składek od elementów wykazywanych na PIT-8AR|&lt;/strong&gt;Rok:&lt;strong&gt; %ROK%|&lt;/strong&gt;Urząd skarbowy:&lt;strong&gt; %URZAD%&lt;/strong&gt;%SKŁADKI%"
				runat="server"></eb:ReportHeader>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%">
				<P>
					<ea:DataLabel id="dlUrzadSkarbowy" runat="server" DataMember="Urzad.Nazwa"></ea:DataLabel><BR>
					<ea:Grid id="Grid1" runat="server" DataMember="Podatnicy">
						<Columns>
							<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
							<ea:GridColumn Width="28" DataMember="NazwiskoImieOkres" Total="Info" Caption="Nazwisko i imię&lt;br&gt;Okres"></ea:GridColumn>
							<ea:GridColumn Width="12" Align="Right" DataMember="Przychod" Total="Sum" Caption="Przych&#243;d"
								Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Koszty" Total="Sum" Caption="Koszty uzyskania" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Width="12" Align="Right" DataMember="Dochod" Total="Sum" Caption="Doch&#243;d" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Podatek" Total="Sum" 
                                Caption="Pobrany podatek" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="ZUS" Total="Sum" Caption="Skł. ub. społeczne" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Pobrane" Total="Sum" Caption="Skł. ub. zdrowotne~pobrana"
								Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="DoOdliczenia" Total="Sum" Caption="Skł. ub. zdrowotne~do odliczenia"
								Format="{0:n}"></ea:GridColumn>
						</Columns>
					</ea:Grid></P>
			</ea:DataRepeater>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</HTML>

